// ===========================
// Layer Name Editor
// ===========================
function script1() {
    app.bringToFront();
main();
function main(){
	if(!documents.length) return;
	var selLayers=getSelectedLayersIdx();
	var selIdxNames=[];
	for(var s in selLayers){
		selIdxNames.push([[Number(selLayers[s])],[getLayerNameByIndex(Number(selLayers[s]))]]);
	}
	selectAllLayers();
	var allLayers = getSelectedLayersIdx();
	var allIdxNames=[];
	for(var n in allLayers){
		allIdxNames.push([[Number(allLayers[n])],[getLayerNameByIndex(Number(allLayers[n]))]]);
	}
	try{
		var win = new Window( 'dialog', 'Layer Name Editor' ); 
		g = win.graphics;
		var myBrush = g.newBrush(g.BrushType.SOLID_COLOR, [0.99, 0.99, 0.99, 1]);
		g.backgroundColor = myBrush;
		win.orientation='column';
		win.p1= win.add("panel", undefined, undefined, {borderStyle:"black"}); 
		win.p1.preferredSize=[480,100];
		win.g1 = win.p1.add('group');
		win.g1.orientation = "row";
		win.title = win.g1.add('statictext',undefined,'Layer Name Editor');
		win.title.alignment="fill";
		var g = win.title.graphics;
		g.font = ScriptUI.newFont("Georgia","BOLDITALIC",22);
		win.g5 =win.p1.add('group');
		win.g5.orientation = "row";
		win.g5.alignment='fill';
		win.g5.spacing=10;
		win.g5.rb1 = win.g5.add('radiobutton',undefined,'Use Selected Layers');
		win.g5.rb2 = win.g5.add('radiobutton',undefined,'Use All Layers');
		win.g5.rb1.value=true;
		win.g10 =win.p1.add('group');
		win.g10.orientation = "row";
		win.g10.alignment='fill';
		win.g10.rb1 = win.g10.add('radiobutton',undefined,'Prefix');
		win.g10.rb2 = win.g10.add('radiobutton',undefined,'Suffix');
		win.g10.rb3 = win.g10.add('radiobutton',undefined,'Remove');
		win.g10.rb4 = win.g10.add('radiobutton',undefined,'Insert');
		win.g10.rb5 = win.g10.add('radiobutton',undefined,'Replace');
		win.g10.rb6 = win.g10.add('radiobutton',undefined,'Rename');
		win.g10.rb1.value=true;
		win.g15 =win.p1.add('group');
		win.g15.orientation = "row";
		win.g15.alignment='fill';
		win.g15.cb1 = win.g15.add('checkbox',undefined,'Create Snapshot');

		win.stack =win.add('group');
		win.stack.spacing=10;
		win.stack.orientation = 'stack';
		win.stack.alignment="left";

		win.p2= win.stack.add("panel", undefined, undefined, {borderStyle:"black"}); //Prefix
		win.p2.preferredSize=[480,100];
		win.p2.visible=false; 
		win.g200 =win.p2.add('group');
		win.g200.orientation = "row";
		win.g200.alignment='fill';
		win.g200.st1 = win.g200.add('statictext',undefined,'Prefix');
		win.g200.st1.preferredSize=[75,20];
		win.g200.et1 = win.g200.add('edittext');
		win.g200.et1.preferredSize=[200,20];

		win.p3= win.stack.add("panel", undefined, undefined, {borderStyle:"black"}); //Suffix
		win.p3.preferredSize=[480,100];
		win.p3.visible=false;
		win.g300 =win.p3.add('group');
		win.g300.orientation = "row";
		win.g300.alignment='fill';
		win.g300.st1 = win.g300.add('statictext',undefined,'Suffix');
		win.g300.st1.preferredSize=[75,20];
		win.g300.et1 = win.g300.add('edittext');
		win.g300.et1.preferredSize=[200,20];

		win.p4= win.stack.add("panel", undefined, undefined, {borderStyle:"black"}); //Remove
		win.p4.preferredSize=[480,100];
		win.p4.visible=false;
		win.g400 =win.p4.add('group');
		win.g400.orientation = "row";
		win.g400.alignment='fill';
		win.g400.rb1 = win.g400.add('radiobutton',undefined,'First(n) chars');
		win.g400.rb2 = win.g400.add('radiobutton',undefined,'Last(n) chars');
		win.g400.rb3 = win.g400.add('radiobutton',undefined,'Range From(n)');
		win.g400.rb1.value=true;
		win.g410 =win.p4.add('group');
		win.g410.orientation = "row";
		win.g410.alignment='fill';
		win.g410.et1 = win.g410.add('edittext');
		win.g410.et1.preferredSize=[50,20];
		win.g410.et1.onChanging = function() { 
			if (this.text.match(/[^\-\.\d]/)) { 
				this.text = this.text.replace(/[^\-\.\d]/g, ''); 
			} 
		};
		win.g410.st1 = win.g410.add('statictext',undefined,'Number of Chars.');
		win.g410.et2 = win.g410.add('edittext');
		win.g410.et2.preferredSize=[50,20];
		win.g410.et2.onChanging = function() { 
			if (this.text.match(/[^\-\.\d]/)) { 
				this.text = this.text.replace(/[^\-\.\d]/g, ''); 
			} 
		};
		win.g410.et2.visible=false;
		win.g410.st1.visible=false;
		win.g400.rb1.onClick=function(){
			win.g410.et2.visible=false;
			win.g410.st1.visible=false;
		}
		win.g400.rb2.onClick=function(){
			win.g410.et2.visible=false;
			win.g410.st1.visible=false;
		}
		win.g400.rb3.onClick=function(){
			win.g410.et2.visible=true;
			win.g410.st1.visible=true;
		}

		win.p5= win.stack.add("panel", undefined, undefined, {borderStyle:"black"}); //Insert
		win.p5.preferredSize=[480,100];
		win.p5.visible=false;
		win.g500 =win.p5.add('group');
		win.g500.orientation = "row";
		win.g500.alignment='fill';
		win.g500.st1 = win.g500.add('statictext',undefined,'Insert');
		win.g500.st1.preferredSize=[75,20];
		win.g500.et1 = win.g500.add('edittext');
		win.g500.et1.preferredSize=[200,20];
		win.g510 =win.p5.add('group');
		win.g510.orientation = "row";
		win.g510.alignment='fill';
		win.g510.st1 = win.g510.add('statictext',undefined,'At position');
		win.g510.st1.preferredSize=[75,20];
		win.g510.et1 = win.g510.add('edittext');
		win.g510.et1.preferredSize=[50,20];
		win.g510.et1.onChanging = function() { 
			if (this.text.match(/[^\-\.\d]/)) { 
				this.text = this.text.replace(/[^\-\.\d]/g, ''); 
			} 
		};

		win.p6= win.stack.add("panel", undefined, undefined, {borderStyle:"black"}); //Replace
		win.p6.preferredSize=[480,100];
		win.g600 =win.p6.add('group');
		win.g600.orientation = "row";
		win.g600.alignment='fill';
		win.g600.st1 = win.g600.add('statictext',undefined,'Replace');
		win.g600.st1.preferredSize=[75,20];
		win.g600.et1 = win.g600.add('edittext');
		win.g600.et1.preferredSize=[200,20];
		win.g610 =win.p6.add('group');
		win.g610.orientation = "row";
		win.g610.alignment='fill';
		win.g610.st1 = win.g610.add('statictext',undefined,'With');
		win.g610.st1.preferredSize=[75,20];
		win.g610.et1 = win.g610.add('edittext');
		win.g610.et1.preferredSize=[200,20];
		win.g620 =win.p6.add('group');
		win.g620.orientation = "row";
		win.g620.alignment='fill';
		win.g620.cb1 = win.g620.add('checkbox',undefined,'Global');
		win.g620.cb2 = win.g620.add('checkbox',undefined,'Case Insensitive');
		win.g620.cb2.value=true;

		win.p7= win.stack.add("panel", undefined, undefined, {borderStyle:"black"}); //Rename
		win.p7.preferredSize=[480,100];
		win.p7.visible=false; 
		win.g700 =win.p7.add('group');
		win.g700.orientation = "row";
		win.g700.alignment='fill';
		win.g700.st1 = win.g700.add('statictext',undefined,'Rename');
		win.g700.st1.preferredSize=[75,20];
		win.g700.et1 = win.g700.add('edittext');
		win.g700.et1.preferredSize=[200,20];

		win.g10.rb1.onClick=function(){
			if(win.g10.rb1.value){
				win.p2.visible=true;
				win.p3.visible=false;
				win.p4.visible=false;
				win.p5.visible=false;
				win.p6.visible=false;
				win.p7.visible=false;
			}
		}
		win.g10.rb2.onClick=function(){
			if(win.g10.rb2.value){
				win.p2.visible=false;
				win.p3.visible=true;
				win.p4.visible=false;
				win.p5.visible=false;
				win.p6.visible=false;
				win.p7.visible=false;
			}
		}
		win.g10.rb3.onClick=function(){
			if(win.g10.rb3.value){
				win.p2.visible=false;
				win.p3.visible=false;
				win.p4.visible=true;
				win.p5.visible=false;
				win.p6.visible=false;
				win.p7.visible=false;
			}
		}
		win.g10.rb4.onClick=function(){
			if(win.g10.rb4.value){
				win.p2.visible=false;
				win.p3.visible=false;
				win.p4.visible=false;
				win.p5.visible=true;
				win.p6.visible=false;
				win.p7.visible=false;
			}
		}
		win.g10.rb5.onClick=function(){
			if(win.g10.rb5.value){
				win.p2.visible=false;
				win.p3.visible=false;
				win.p4.visible=false;
				win.p5.visible=false;
				win.p6.visible=true;
				win.p7.visible=false;
			}
		}

		win.g10.rb6.onClick=function(){
			if(win.g10.rb6.value){
				win.p2.visible=false;
				win.p3.visible=false;
				win.p4.visible=false;
				win.p5.visible=false;
				win.p6.visible=false;
				win.p7.visible=true;
			}
		}

		win.g1000 =win.add('group');
		win.g1000.orientation = "row";
		win.g1000.alignment='center';
		win.g1000.bu1 = win.g1000.add('button',undefined,'Process');
		win.g1000.bu1.preferredSize=[150,30];
		win.g1000.bu2 = win.g1000.add('button',undefined,'Cancel');
		win.g1000.bu2.preferredSize=[150,30];
		snapshotFlag = false;
		win.g1000.bu1.onClick=function(){
			if(win.g15.cb1.value && !snapshotFlag){
				snapshotFlag=true;
				snapShot();
			}
			if(win.g10.rb1.value){//Prefix
				if(win.g200.et1.text == ''){
					alert("No Prefix has been entered!");
					return;
				}
				win.close(0);
				if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
				for(var z in lList){
					putLayerNameByIndex( Number(lList[z][0]), win.g200.et1.text.toString() + lList[z][1].toString());
				}
			}
			if(win.g10.rb2.value){//suffix
				if(win.g300.et1.text == ''){
					alert("No Suffix has been entered!");
					return;
				}
				win.close(0);
				if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
				for(var z in lList){
					putLayerNameByIndex( Number(lList[z][0]), lList[z][1].toString() + win.g300.et1.text.toString());
				}
			}
			if(win.g10.rb3.value){//Remove
				if(win.g400.rb1.value){
					if(win.g410.et1.text == ''){
						alert("No number has been entered!");
						return;
					}
					if(Number(win.g410.et1.text) <1 ){
						alert("You can't remove zero characters!");
						return;
					}
					win.close(0);
					if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
					for(var z in lList){
						var n = Number(win.g410.et1.text);
						var rex = "/^(.{"+ n+"})(.+)/";
						putLayerNameByIndex( Number(lList[z][0]), lList[z][1].toString().match(eval(rex))[2]);
					}
				}
				if(win.g400.rb2.value){
					if(win.g410.et1.text == ''){
						alert("No number has been entered!");
						return;
					}
					if(Number(win.g410.et1.text) <1 ){
						alert("You can't remove zero characters!");
						return;
					}
					win.close(0);
					if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
					for(var z in lList){
						var n = Number(win.g410.et1.text);
						var rex = "/(.+)(.{"+n+"}$)/";
						putLayerNameByIndex( Number(lList[z][0]), lList[z][1].toString().match(eval(rex))[1]);
					}
				}
				if(win.g400.rb3.value){
					if(win.g410.et1.text == '' || win.g410.et2.text == ''){
						alert("No number has been entered!");
						return;
					}
					if(Number(win.g410.et1.text) <1 || Number(win.g410.et2.text) <1 ){
						alert("You can't remove zero characters!");
						return;
					}
					win.close(0);
					if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
					for(var z in lList){
						var n = Number(win.g410.et1.text);
						var r = Number(win.g410.et2.text);
						var rex = "/^(.{"+ n+"})(.{"+r+"})(.+)/";
						var parts = lList[z][1].toString().match(eval(rex));
						var newName = parts[1] + parts[3];
						putLayerNameByIndex( Number(lList[z][0]), newName);
					}
				}
			}
			if(win.g10.rb4.value){//Insert
				if(win.g500.et1.text == ''){
					alert("You have not entered a string!");
					return;
				}
				if(win.g510.et1.text == ''){
					alert("You must enter a start number!");
					return;
				}
				win.close(0);
				if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
				for(var z in lList){
					var n = Number(win.g510.et1.text);
					if(n<1) n=1;
					var rex = "/^(.{"+ n+"})(.+)/";
					var parts = lList[z][1].toString().match(eval(rex));
					var newName = parts[1] + win.g500.et1.text.toString()+ parts[2];
					putLayerNameByIndex( Number(lList[z][0]), newName);
				}
			}
			if(win.g10.rb5.value){//Replace
				if(win.g600.et1.text == ''){
					alert("No replace value has been entered!");
					return;
				}
				win.close(0);
				if(win.g620.cb1.value && !win.g620.cb2.value) var changeFrom = new RegExp (win.g600.et1.text.toString(),"g");
				if(!win.g620.cb1.value && win.g620.cb2.value) var changeFrom = new RegExp (win.g600.et1.text.toString(),"i");
				if(win.g620.cb1.value && win.g620.cb2.value) var changeFrom = new RegExp (win.g600.et1.text.toString(),"gi");
				if(!win.g620.cb1.value && !win.g620.cb2.value) var changeFrom = new RegExp (win.g600.et1.text.toString());
				if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
				for(var z in lList){
					if(changeFrom.test( lList[z][1].toString())){
						putLayerNameByIndex( Number(lList[z][0]), lList[z][1].toString().replace(changeFrom,win.g610.et1.text.toString())); 
					}
				}
			}    
		
            if(win.g10.rb6.value){//Rename
				if(win.g700.et1.text == ''){
					alert("No new name has been entered!");
					return;
				}
				win.close(0);
				if(win.g5.rb1.value){var lList = selIdxNames;}else{var lList=allIdxNames;};
				for(var z in lList){
					putLayerNameByIndex( Number(lList[z][0]), win.g700.et1.text.toString());
				}
			}
        
        }
		}catch(e){alert(e + " - " + e.line);}
		win.center();
		win.show();
	};
	function selectLayerByIndex(index,add){ 
		add = (add == undefined)  ? add = false : add;
		var ref = new ActionReference();
		ref.putIndex(charIDToTypeID("Lyr "), index);
		var desc = new ActionDescriptor();
		desc.putReference(charIDToTypeID("null"), ref );
		if(add) desc.putEnumerated( stringIDToTypeID( "selectionModifier" ), stringIDToTypeID( "selectionModifierType" ), stringIDToTypeID( "addToSelection" ) ); 
		desc.putBoolean( charIDToTypeID( "MkVs" ), false ); 
		try{ executeAction(charIDToTypeID("slct"), desc, DialogModes.NO );}catch(e){}
	};
	function getLayerNameByIndex( idx ) { 
		var ref = new ActionReference(); 
		ref.putProperty( charIDToTypeID("Prpr") , charIDToTypeID( "Nm  " )); 
		ref.putIndex( charIDToTypeID( "Lyr " ), idx );
		return executeActionGet(ref).getString(charIDToTypeID( "Nm  " ));
	};
	function selectAllLayers() {
		var desc29 = new ActionDescriptor();
		var ref23 = new ActionReference();
		ref23.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );
		desc29.putReference( charIDToTypeID('null'), ref23 );
		executeAction( stringIDToTypeID('selectAllLayers'), desc29, DialogModes.NO );
	};
	function getSelectedLayersIdx(){ 
		var selectedLayers = new Array; 
		var ref = new ActionReference(); 
		ref.putEnumerated( charIDToTypeID("Dcmn"), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") ); 
		var desc = executeActionGet(ref); 
		if( desc.hasKey( stringIDToTypeID( 'targetLayers' ) ) ){ 
			desc = desc.getList( stringIDToTypeID( 'targetLayers' )); 
			var c = desc.count 
			var selectedLayers = new Array(); 
			for(var i=0;i<c;i++){ 
				try{ 
					activeDocument.backgroundLayer; 
					selectedLayers.push(  desc.getReference( i ).getIndex() ); 
				}catch(e){ 
					selectedLayers.push(  desc.getReference( i ).getIndex()+1 ); 
				} 
			} 
		}else{ 
			var ref = new ActionReference(); 
			ref.putProperty( charIDToTypeID("Prpr") , charIDToTypeID( "ItmI" )); 
			ref.putEnumerated( charIDToTypeID("Lyr "), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") ); 
			try{ 
				activeDocument.backgroundLayer; 
				selectedLayers.push( executeActionGet(ref).getInteger(charIDToTypeID( "ItmI" ))-1); 
			}catch(e){ 
				selectedLayers.push( executeActionGet(ref).getInteger(charIDToTypeID( "ItmI" ))); 
			} 
			var vis = app.activeDocument.activeLayer.visible;
			if(vis == true) app.activeDocument.activeLayer.visible = false;
			var desc9 = new ActionDescriptor();
			var list9 = new ActionList();
			var ref9 = new ActionReference();
			ref9.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );
			list9.putReference( ref9 );
			desc9.putList( charIDToTypeID('null'), list9 );
			executeAction( charIDToTypeID('Shw '), desc9, DialogModes.NO );
			if(app.activeDocument.activeLayer.visible == false) selectedLayers.shift();
			app.activeDocument.activeLayer.visible = vis;
		} 
		return selectedLayers; 
	};
	function snapShot() {
		var desc9 = new ActionDescriptor();
		var ref5 = new ActionReference();
		ref5.putClass( charIDToTypeID('SnpS') );
		desc9.putReference( charIDToTypeID('null'), ref5 );
		var ref6 = new ActionReference();
		ref6.putProperty( charIDToTypeID('HstS'), charIDToTypeID('CrnH') );
		desc9.putReference( charIDToTypeID('From'), ref6 );
		desc9.putEnumerated( charIDToTypeID('Usng'), charIDToTypeID('HstS'), charIDToTypeID('FllD') );
		executeAction( charIDToTypeID('Mk  '), desc9, DialogModes.NO );
	};
	function putLayerNameByIndex( idx, name ) {
		if( idx == 0 ) return;
		var desc = new ActionDescriptor();
		var ref = new ActionReference();
		ref.putIndex( charIDToTypeID( 'Lyr ' ), idx );
		desc.putReference( charIDToTypeID('null'), ref );
		desc.putBoolean( charIDToTypeID( "MkVs" ), false ); 
		var nameDesc = new ActionDescriptor();
		nameDesc.putString( charIDToTypeID('Nm  '), name );
		desc.putObject( charIDToTypeID('T   '), charIDToTypeID('Lyr '), nameDesc );
		executeAction( charIDToTypeID( 'slct' ), desc, DialogModes.NO ); 
		executeAction( charIDToTypeID('setd'), desc, DialogModes.NO );
	};
}

// ===========================
// Remove Unused Effects
// ===========================
function script2() {
    app.bringToFront();

app.activeDocument.suspendHistory('Remove Unused FX', 'main()');

function main(){
if(!documents.length) return;
selectAllLayers();
var selLayers = getSelectedLayersIdx();
for(var a in selLayers){
clearUnusedFX(Number(selLayers[a]));
    }
}
function clearUnusedFX(idx){
var ref = new ActionReference(); 
ref.putProperty( charIDToTypeID("Prpr") , stringIDToTypeID( "layerEffects" )); 
ref.putIndex( charIDToTypeID( "Lyr " ), idx);
var desc = executeActionGet(ref);
if(desc.hasKey(stringIDToTypeID('layerEffects'))){
makeActiveByIndex( idx );
var FXs = desc.getObjectValue(stringIDToTypeID('layerEffects'));
var ref9 = new ActionReference(); 
ref9.putProperty( charIDToTypeID("Prpr") , stringIDToTypeID( 'layerFXVisible')); 
ref9.putIndex( charIDToTypeID( "Lyr " ), idx);
var vis = executeActionGet(ref9);
var delALL = undefined;
if(vis.hasKey(stringIDToTypeID('layerFXVisible')))  delALL =  vis.getBoolean(stringIDToTypeID('layerFXVisible'));
    }else{
        return;
        }
var c = FXs.count;
var Effects= new Array();
for(var i=0;i<c;i++){ 
  Effects.push(typeIDToStringID(FXs.getKey(i)));
}
for(var z in Effects){
if(z == 0) continue;
var bool = FXs.getObjectValue(stringIDToTypeID(Effects[z].toString())).getBoolean (stringIDToTypeID('enabled'));
if(!bool || delALL == false) delFx(Effects[z].toString());
}
function delFx(fx){
var desc147 = new ActionDescriptor();
var ref45 = new ActionReference();
switch(fx.toString()){
        case 'dropShadow' : ref45.putClass(charIDToTypeID('DrSh')); break;
        case 'innerShadow' : ref45.putClass(charIDToTypeID('IrSh')); break;
        case 'outerGlow' : ref45.putClass(charIDToTypeID('OrGl')); break;
        case 'innerGlow' : ref45.putClass(charIDToTypeID('IrGl')); break;
        case 'bevelEmboss' :ref45.putClass(charIDToTypeID('ebbl')); break;
        case 'frameFX' : ref45.putClass(charIDToTypeID('FrFX')); break;
        case 'chromeFX' : ref45.putClass(charIDToTypeID('ChFX')); break;
        case 'solidFill' : ref45.putClass(charIDToTypeID('SoFi')); break;
        case 'gradientFill' : ref45.putClass(charIDToTypeID('GrFl')); break;
        case 'patternFill' : ref45.putClass(stringIDToTypeID('patternFill')); break;
        default : break;
        }       
ref45.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );
desc147.putReference( charIDToTypeID('null'), ref45 );
try{
executeAction( charIDToTypeID('dsfx'), desc147, DialogModes.NO );   
}catch(e){}
    }
};
function makeActiveByIndex( idx ){ 
    var desc = new ActionDescriptor(); 
      var ref = new ActionReference(); 
      ref.putIndex(charIDToTypeID( "Lyr " ), idx) 
      desc.putReference( charIDToTypeID( "null" ), ref ); 
      desc.putBoolean( charIDToTypeID( "MkVs" ), false ); 
   executeAction( charIDToTypeID( "slct" ), desc, DialogModes.NO ); 
}; 
function selectAllLayers() {
    var desc29 = new ActionDescriptor();
        var ref23 = new ActionReference();
        ref23.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );
    desc29.putReference( charIDToTypeID('null'), ref23 );
    executeAction( stringIDToTypeID('selectAllLayers'), desc29, DialogModes.NO );
}
function getSelectedLayersIdx(){
 	var selectedLayers = new Array;
 	var ref = new ActionReference();
 	ref.putEnumerated( charIDToTypeID("Dcmn"), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") );
 	var desc = executeActionGet(ref);
 	if( desc.hasKey( stringIDToTypeID( 'targetLayers' ) ) ){
 		desc = desc.getList( stringIDToTypeID( 'targetLayers' ));
 		 var c = desc.count 
 		 var selectedLayers = new Array();
 		 for(var i=0;i<c;i++){
 			try{ 
 				activeDocument.backgroundLayer;
 				selectedLayers.push(  desc.getReference( i ).getIndex() );
 			}catch(e){
 				selectedLayers.push(  desc.getReference( i ).getIndex()+1 );
 			}
 		 }
 	 }else{
 		var ref = new ActionReference(); 
 		ref.putProperty( charIDToTypeID("Prpr") , charIDToTypeID( "ItmI" )); 
 		ref.putEnumerated( charIDToTypeID("Lyr "), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") );
 		try{ 
 			activeDocument.backgroundLayer;
 			selectedLayers.push( executeActionGet(ref).getInteger(charIDToTypeID( "ItmI" ))-1);
 		}catch(e){
 			selectedLayers.push( executeActionGet(ref).getInteger(charIDToTypeID( "ItmI" )));
 		}
 	}
 	return selectedLayers;
};
}

// ===========================
// Flatten All Layers Effects
// ===========================
function script3() {
    strFlattenAllLayerEffectsHistoryStepName = "Flatten All Layer Effects";

/////////////////////////
// MAIN
/////////////////////////

// remember the document
var doc = app.activeDocument; 

var flattenAll = true;
    
    var okButtonID = 1;
    var cancelButtonID = 2;
    
// Create only one history state for the entire script
doc.suspendHistory(strFlattenAllLayerEffectsHistoryStepName, "main()");


/////////////////////////
// FUNCTIONS
/////////////////////////
function mainDialog()
{

     var dlg = new Window('dialog', 'Flatten Layer Effects');

    var d = dlg;

   
	d.margins=15;

    var gr1 = d.add('group');
	gr1.orientation = 'row';
    gr1.alignChildren = 'center';
	
    var flattenAllRadio = gr1.add('radiobutton',undefined,"All Layers");
    flattenAllRadio.value = flattenAll;
    gr1.add('radiobutton',undefined,"Selected");
    
    d.c2 = d.add('group');	
    d.c2.margins = 5;
    d.c2.orientation = 'row';
    d.c2.alignChildren = 'center';
    var okButton = d.c2.add('button', undefined, 'OK', {
        name: 'ok'
    });
    d.c2.add('button', undefined, 'Cancel', {
        name: 'cancel'
    });


//events
    okButton.onClick = function()
    {
        flattenAll = flattenAllRadio.value;
        d.close(okButtonID);
    }

    
    return d.show();
}

///////////////////////////////////////////////////////////////////////////////
// Function: main
// Usage: container function to hold all the working code that generates history states
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function main(){
	

    if(doc.layers.length > 1)
    {
            if(mainDialog() != okButtonID) return;
            
    }

	var currentLayer = doc.activeLayer; // remember the selected layer
	var currentVisible = currentLayer.visible; // remember the visibility setting of the selected layer
	var currentSelectedLayers = getSelectedLayers(); // remember the selected layers

	if (currentSelectedLayers.length < 1){
		var currentLayer = activeDocument.activeLayer; // remember the selected layers
	}

	// create an array and store all the art layers states
	var currentState = new Array;
	try{ 
		getCurrentStateAlteringAsNeeded(activeDocument, currentState);
	}catch(e) {
		; // do nothing
	}
	
	// Do some voodoo on the layer selection incase no layer is selected or multiple layers are selected
	try{ 
		touchUpLayerSelection()
	}catch(e) {
		; // do nothing
	}
	
	// create an array and store all the art layers in that array
	var allArtLayers = new Array;
	var allVisibleInfo = new Array;
	getAllArtLayers(doc, allArtLayers, allVisibleInfo);
    


	// Walk the layer stack
    if(flattenAll)
    {
	for (var i = 0; i < allArtLayers.length; i++){ 
		try{ 
			doc.activeLayer = allArtLayers[i];
			if (hasLayerStyle() == true){ // Only if the has a layer style
					flattenLayerStyles(); // Flatten the styles into the layer
				}
		}catch(e) {}
	}
    }

    else
    {


    if (currentSelectedLayers.length < 1){
        try{
		doc.activeLayer = currentLayer; 
        	if (hasLayerStyle() == true){ // Only if the has a layer style
					flattenLayerStyles(); // Flatten the styles into the layer
				}
         }catch(e) {}   
	}

    var decrement = doc.artLayers[activeDocument.artLayers.length-1].isBackgroundLayer ? 0 : 1 ;
    
    
	for (var i = 0; i < currentSelectedLayers.length; i++){ 
		try{ 
			doc.activeLayer = allArtLayers[allArtLayers.length-1-currentSelectedLayers[i]+decrement];
			if (hasLayerStyle() == true){ // Only if the has a layer style
					flattenLayerStyles(); // Flatten the styles into the layer
				}
		}catch(e) {}
	}

    }//end else

	// restore the current state of the layers
	try{ 
		setCurrentState(currentState);
	}catch(e) {
		; // do nothing
	}
	if (currentSelectedLayers.length > 1){
		try{ 
			setSelectedLayers(currentSelectedLayers);
		}catch(e) {
			; // do nothing
		}
	}

	// restore the selected layer
	try{ 
		doc.activeLayer = currentLayer;
	}catch(e) {
		; // do nothing
	}

	// restore the visibility setting of the original layer
	try{ 
		currentLayer.visible = currentVisible;
	}catch(e) {
		; // do nothing
	}

}

///////////////////////////////////////////////////////////////////////////////
// Function: touchUpLayerSelection
// Usage: deal with odd layer selections of no layer selected or multiple layers
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function touchUpLayerSelection() {
	try{ 
		// Select all Layers
		var idselectAllLayers = stringIDToTypeID( "selectAllLayers" );
			var desc252 = new ActionDescriptor();
			var idnull = charIDToTypeID( "null" );
				var ref174 = new ActionReference();
				var idLyr = charIDToTypeID( "Lyr " );
				var idOrdn = charIDToTypeID( "Ordn" );
				var idTrgt = charIDToTypeID( "Trgt" );
				ref174.putEnumerated( idLyr, idOrdn, idTrgt );
			desc252.putReference( idnull, ref174 );
		executeAction( idselectAllLayers, desc252, DialogModes.NO );
		// Select the previous layer
		var idslct = charIDToTypeID( "slct" );
			var desc209 = new ActionDescriptor();
			var idnull = charIDToTypeID( "null" );
				var ref140 = new ActionReference();
				var idLyr = charIDToTypeID( "Lyr " );
				var idOrdn = charIDToTypeID( "Ordn" );
				var idBack = charIDToTypeID( "Back" );
				ref140.putEnumerated( idLyr, idOrdn, idBack );
			desc209.putReference( idnull, ref140 );
			var idMkVs = charIDToTypeID( "MkVs" );
			desc209.putBoolean( idMkVs, false );
		executeAction( idslct, desc209, DialogModes.NO );
	}catch(e) {
		; // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: hasLayerStyle
// Usage: see if there are styles present on a layer
// Input: <none> Must have an open document
// Return: true if there is a layer style/effect present
///////////////////////////////////////////////////////////////////////////////
function hasLayerStyle() {
	var hasLayerStyle = false;
	try {
		var ref = new ActionReference();
		var keyLayerEffects = app.charIDToTypeID( 'Lefx' );
		ref.putProperty( app.charIDToTypeID( 'Prpr' ), keyLayerEffects );
		ref.putEnumerated( app.charIDToTypeID( 'Lyr ' ), app.charIDToTypeID( 'Ordn' ), app.charIDToTypeID( 'Trgt' ) );
		var desc = executeActionGet( ref );
		if ( desc.hasKey( keyLayerEffects ) ) {
			hasLayerStyle = true;
		}
	}catch(e) {
		hasLayerStyle = false;
	}
	return hasLayerStyle;
}

///////////////////////////////////////////////////////////////////////////////
// Function: flattenLayerStyles
// Usage: worker function for flattening styles into the layer
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function flattenLayerStyles() {
	try {
		var targetLayer = app.activeDocument.activeLayer.name; // Remember the layers name
		makeLayerBelow(targetLayer); // Make a new layer below with the target layers name
		selectPreviousLayer(); // select the previous layer
		mergeDown(); // and merge it down
	}catch(e) {
		; // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: makeLayerBelow
// Usage: Creates a new layer below with the target layers name
// Input: targetName. the name of the layer we want to create a new layer below
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function makeLayerBelow(targetName) {
	try {
		var id829 = charIDToTypeID( "Mk  " );
			var desc169 = new ActionDescriptor();
			var id830 = charIDToTypeID( "null" );
				var ref105 = new ActionReference();
				var id831 = charIDToTypeID( "Lyr " );
				ref105.putClass( id831 );
			desc169.putReference( id830, ref105 );
			var id832 = stringIDToTypeID( "below" );
			desc169.putBoolean( id832, true );
			var id833 = charIDToTypeID( "Usng" );
				var desc170 = new ActionDescriptor();
				var id834 = charIDToTypeID( "Nm  " );
				desc170.putString( id834, targetName );
			var id835 = charIDToTypeID( "Lyr " );
			desc169.putObject( id833, id835, desc170 );
		executeAction( id829, desc169, DialogModes.NO );
	}catch(e) {
		; // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: selectPreviousLayer
// Usage: Selects the layer above the selected layer, adding that layer to the current layer selection
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function selectPreviousLayer() {
	try {
		var idslct = charIDToTypeID( "slct" );
			var desc9 = new ActionDescriptor();
			var idnull = charIDToTypeID( "null" );
				var ref8 = new ActionReference();
				var idLyr = charIDToTypeID( "Lyr " );
				var idOrdn = charIDToTypeID( "Ordn" );
				var idFrwr = charIDToTypeID( "Frwr" );
				ref8.putEnumerated( idLyr, idOrdn, idFrwr );
			desc9.putReference( idnull, ref8 );
			var idselectionModifier = stringIDToTypeID( "selectionModifier" );
			var idselectionModifierType = stringIDToTypeID( "selectionModifierType" );
			var idaddToSelection = stringIDToTypeID( "addToSelection" );
			desc9.putEnumerated( idselectionModifier, idselectionModifierType, idaddToSelection );
			var idMkVs = charIDToTypeID( "MkVs" );
			desc9.putBoolean( idMkVs, false );
		executeAction( idslct, desc9, DialogModes.NO );
	}catch(e) {
		; // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: mergeDown
// Usage: merges the currently selected layers into one layer. If only one layer is selected it merges the current layer down into the layer below
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function mergeDown() {
	try {
		var id828 = charIDToTypeID( "Mrg2" );
			var desc168 = new ActionDescriptor();
		executeAction( id828, desc168, DialogModes.NO );
	}catch(e) {
		; // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: getAllArtLayers
// Usage: get a reference to all artLayers in 
// the document, does recursion into groups
// Input: obj, current object, document or layerSet
// layersArray, place to put the resulting artLayers,
// layersArray is both input and output
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function getAllArtLayers(obj, layersArray, visibleArray) {
	for( var i = 0; i < obj.artLayers.length; i++) {
		layersArray.push(obj.artLayers[i]);
		//alert(obj.artLayers[i].name);
		visibleArray.push(obj.artLayers[i].visible);
	}
	for( var i = 0; i < obj.layerSets.length; i++) {
		getAllArtLayers(obj.layerSets[i], layersArray, visibleArray);	// recursive call
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: getSelectedLayers
// Usage: creates and array of the currently selected layers
// Input: <none> Must have an open document
// Return: Array selectedLayers
///////////////////////////////////////////////////////////////////////////////
function getSelectedLayers() {
	var selectedLayers = [];
	try {
		var backGroundCounter = activeDocument.artLayers[activeDocument.artLayers.length-1].isBackgroundLayer ? 0 : 1;
		var ref = new ActionReference();
		var keyTargetLayers = app.stringIDToTypeID( 'targetLayers' );
		ref.putProperty( app.charIDToTypeID( 'Prpr' ), keyTargetLayers );
		ref.putEnumerated( app.charIDToTypeID( 'Dcmn' ), app.charIDToTypeID( 'Ordn' ), app.charIDToTypeID( 'Trgt' ) );
		var desc = executeActionGet( ref );
		if ( desc.hasKey( keyTargetLayers ) ) {
			var layersList = desc.getList( keyTargetLayers );
			for ( var i = 0; i < layersList.count; i++) {
				var listRef = layersList.getReference( i );
				selectedLayers.push( listRef.getIndex() + backGroundCounter );
			}
		}
	}
	catch(e) {
		; // do nothing
	}
	return selectedLayers;
}

///////////////////////////////////////////////////////////////////////////////
// Function: setSelectedLayers
// Usage: Selects an array of layers
// Input:  Array selectedLayers
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function setSelectedLayers( layerIndexesOrNames ) {
	// first select the first one
	setSelectedLayer( layerIndexesOrNames[0] );

	// then add to the selection
	for ( var i = 1; i < layerIndexesOrNames.length; i++) {
		addSelectedLayer( layerIndexesOrNames[i] );
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: setSelectedLayer
// Usage: Selects the first layer
// Input:  Array selectedLayers
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function setSelectedLayer( layerIndexOrName ) {
	try {
		var id239 = charIDToTypeID( "slct" );
		var desc45 = new ActionDescriptor();
		var id240 = charIDToTypeID( "null" );
		var ref43 = new ActionReference();
		var id241 = charIDToTypeID( "Lyr " );
		if ( typeof layerIndexOrName == "number" ) {
			ref43.putIndex( id241, layerIndexOrName );
		} else {
			ref43.putName( id241, layerIndexOrName );
		}
		desc45.putReference( id240, ref43 );
		var id242 = charIDToTypeID( "MkVs" );
		desc45.putBoolean( id242, false );
		executeAction( id239, desc45, DialogModes.NO );
	}
	catch(e) {
		alert(e + ":" + e.line); // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: addSelectedLayer
// Usage: adds the rest of the layers in the array to the first layer
// Input:  Array selectedLayers
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function addSelectedLayer( layerIndexOrName ) {
	try {
		var id243 = charIDToTypeID( "slct" );
		var desc46 = new ActionDescriptor();
		var id244 = charIDToTypeID( "null" );
		var ref44 = new ActionReference();
		var id245 = charIDToTypeID( "Lyr " );
		if ( typeof layerIndexOrName == "number" ) {
			ref44.putIndex( id245, layerIndexOrName );
		} else {
			ref44.putName( id245, layerIndexOrName );
		}
		desc46.putReference( id244, ref44 );
		var id246 = stringIDToTypeID( "selectionModifier" );
		var id247 = stringIDToTypeID( "selectionModifierType" );
		var id248 = stringIDToTypeID( "addToSelection" );
		desc46.putEnumerated( id246, id247, id248 );
		var id249 = charIDToTypeID( "MkVs" );
		desc46.putBoolean( id249, false );
		executeAction( id243, desc46, DialogModes.NO );
	}
	catch(e) {
		alert(e + ":" + e.line); // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function:  getCurrentStateAlteringAsNeeded
// Usage: capture the current state of the layers in an array
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function getCurrentStateAlteringAsNeeded( obj, stateArray ) {
	for( var i = 0; i < obj.artLayers.length; i++) {
		var oState = new ObjectState(obj.artLayers[i]);
		if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].visible, true)) {
			obj.artLayers[i].visible = true;
		}
		if ( ! obj.artLayers[i].isBackgroundLayer) {
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].allLocked, false)) {
				obj.artLayers[i].allLocked = false;
			}
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].pixelsLocked, false)) {
				obj.artLayers[i].pixelsLocked = false;
			}
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].positionLocked, false)) {
				obj.artLayers[i].positionLocked = false;
			}
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].transparentPixelsLocked, false)) {
				obj.artLayers[i].transparentPixelsLocked = false;
			}
		}
		stateArray.push(oState);
	}
	for( var i = 0; i < obj.layerSets.length; i++ ) {
		var oState = new ObjectState(obj.layerSets[i]);
		if ( oState.fixState( obj.layerSets[i], obj.layerSets[i].visible, true)) {
			obj.layerSets[i].visible = true;
		}
		if ( oState.fixState( obj.layerSets[i], obj.layerSets[i].allLocked, false)) {
			obj.layerSets[i].allLocked = false;
		}
		stateArray.push(oState);
		getCurrentStateAlteringAsNeeded(obj.layerSets[i], stateArray);	// recursive call
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function:  setCurrentState
// Usage: set the state of the layers back to what what captured
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function setCurrentState(stateArray) {
	for ( var i = 0; i < stateArray.length; i++ ) {
		try {
			if (stateArray[i].altered) {
				app.refresh();
				activeDocument.activeLayer = stateArray[i].layer;
				stateArray[i].layer.allLocked = stateArray[i].allLocked;
				if ( ! stateArray[i].allLocked) {
					stateArray[i].layer.pixelsLocked = stateArray[i].pixelsLocked;
					stateArray[i].layer.positionLocked = stateArray[i].positionLocked;
					stateArray[i].layer.transparentPixelsLocked = stateArray[i].transparentPixelsLocked;
				}
				stateArray[i].layer.visible = stateArray[i].visible;
			}
		}
		catch(e) { alert(e + ":" + e.line); }
	}
}


///////////////////////////////////////////////////////////////////////////////
// Function:  ObjectState
// Usage: 
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function ObjectState( inObject ) {
	this.layer = inObject;
	this.visible = inObject.visible;
	this.allLocked = inObject.allLocked;
	this.pixelsLocked = inObject.pixelsLocked;
	this.positionLocked = inObject.positionLocked;
	this.transparentPixelsLocked = inObject.transparentPixelsLocked;
	this.altered = false;
	this.current = false;
	this.fixState = function (inObject, inState, wantState) {
		var wasAltered = false;
		if (inState != wantState) {
			if (this.current == false) {
				activeDocument.activeLayer = inObject;
				this.altered = true;
				this.current = true;
			}
			wasAltered = true;
		}
		return wasAltered;
	}
}
}

// ===========================
// Delete Empty Layers
// ===========================
function script4() {
    main();
function main(){
if(!documents.length) return;
var layerInfo = getLayerInfo();
for(var a in layerInfo){//delete blank layers
    if(layerInfo[a][2] == 'false') deleteLayerByID(Number(layerInfo[a][0]));
    }
for(var z in layerInfo){
     if(layerInfo[z][2] == 'true'){//delete empty layerSets
         selectLayerById(Number(layerInfo[z][0]));
         if(activeDocument.activeLayer.layers.length == 0) deleteLayerByID(Number(layerInfo[z][0]));
         }
    }
};
function deleteLayerByID(ID) {
    var desc = new ActionDescriptor();
        var ref = new ActionReference();
        ref.putIdentifier(charIDToTypeID('Lyr '), ID);
    desc.putReference( charIDToTypeID('null'), ref );
    executeAction( charIDToTypeID('Dlt '), desc, DialogModes.NO );
};
function selectLayerById(ID, add) {
    add = (add == undefined)  ? add = false : add;
   var ref = new ActionReference();
   ref.putIdentifier(charIDToTypeID('Lyr '), ID);
   var desc = new ActionDescriptor();
   desc.putReference(charIDToTypeID('null'), ref);
   if (add) {
      desc.putEnumerated(stringIDToTypeID('selectionModifier'), stringIDToTypeID('selectionModifierType'), stringIDToTypeID('addToSelection'));
   }
   desc.putBoolean(charIDToTypeID('MkVs'), false);
   executeAction(charIDToTypeID('slct'), desc, DialogModes.NO);
}
function getLayerInfo(){ 
   var ref = new ActionReference(); 
   ref.putEnumerated( charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') ); 
   var count = executeActionGet(ref).getInteger(charIDToTypeID('NmbL')) +1; 
   var Names=[];
try{
    activeDocument.backgroundLayer;
var i = 0; }catch(e){ var i = 1; };
   for(i;i<count;i++){ 
       if(i == 0) continue;
        ref = new ActionReference(); 
        ref.putIndex( charIDToTypeID( 'Lyr ' ), i );
        var desc = executeActionGet(ref);
        var layerName = desc.getString(charIDToTypeID( 'Nm  ' ));
        var Id = desc.getInteger(stringIDToTypeID( 'layerID' ));
        if(layerName.match(/^<\/Layer group/) ) continue;
        var layerType = typeIDToStringID(desc.getEnumerationValue( stringIDToTypeID( 'layerSection' )));
        var isLayerSet =( layerType == 'layerSectionContent') ? false:true;
        var boundsDesc = desc.getObjectValue(stringIDToTypeID( "bounds" ));
if(boundsDesc.getUnitDoubleValue(stringIDToTypeID('right')) - boundsDesc.getUnitDoubleValue(stringIDToTypeID('left')) == 0){
    Names.push([[Id],[layerName],[isLayerSet]]);
    }
if(isLayerSet) Names.push([[Id],[layerName],[isLayerSet]]);
   }; 
return Names;
};
}

// ===========================
// Rasterize Smart Object
// ===========================
function script5() {
    app.bringToFront();
activeDocument.suspendHistory('Raster SOs', 'main()');
function main(){
if(!documents.length) return;
selectAllLayers();
var selectedLayers = getSelectedLayersIdx();
for(var a in selectedLayers){
if(hasSmartObject(Number(selectedLayers[a]))){
makeActiveByIndex(Number(selectedLayers[a]),false);
executeAction( stringIDToTypeID( "rasterizePlaced" ), undefined, DialogModes.NO );
    }
}
}
function hasSmartObject(idx){
var ref = new ActionReference(); 
ref.putProperty( charIDToTypeID("Prpr") , stringIDToTypeID( "smartObject" )); 
ref.putIndex( charIDToTypeID( "Lyr " ), idx);
var desc = executeActionGet(ref);
if(desc.hasKey(stringIDToTypeID('smartObject')))  return true; else return false;
}
function makeActiveByIndex( idx, visible ){ 
    var desc = new ActionDescriptor(); 
      var ref = new ActionReference(); 
      ref.putIndex(charIDToTypeID( "Lyr " ), idx) 
      desc.putReference( charIDToTypeID( "null" ), ref ); 
      desc.putBoolean( charIDToTypeID( "MkVs" ), visible ); 
   executeAction( charIDToTypeID( "slct" ), desc, DialogModes.NO ); 
};
function getSelectedLayersIdx(){
 	var selectedLayers = new Array;
 	var ref = new ActionReference();
 	ref.putEnumerated( charIDToTypeID("Dcmn"), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") );
 	var desc = executeActionGet(ref);
 	if( desc.hasKey( stringIDToTypeID( 'targetLayers' ) ) ){
 		desc = desc.getList( stringIDToTypeID( 'targetLayers' ));
 		 var c = desc.count 
 		 var selectedLayers = new Array();
 		 for(var i=0;i<c;i++){
 			try{ 
 				activeDocument.backgroundLayer;
 				selectedLayers.push(  desc.getReference( i ).getIndex() );
 			}catch(e){
 				selectedLayers.push(  desc.getReference( i ).getIndex()+1 );
 			}
 		 }
 	 }else{
 		var ref = new ActionReference(); 
 		ref.putProperty( charIDToTypeID("Prpr") , charIDToTypeID( "ItmI" )); 
 		ref.putEnumerated( charIDToTypeID("Lyr "), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") );
 		try{ 
 			activeDocument.backgroundLayer;
 			selectedLayers.push( executeActionGet(ref).getInteger(charIDToTypeID( "ItmI" ))-1);
 		}catch(e){
 			selectedLayers.push( executeActionGet(ref).getInteger(charIDToTypeID( "ItmI" )));
 		}
 	}
 	return selectedLayers;
};
function selectAllLayers() {
    var desc29 = new ActionDescriptor();
        var ref23 = new ActionReference();
        ref23.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );
    desc29.putReference( charIDToTypeID('null'), ref23 );
    executeAction( stringIDToTypeID('selectAllLayers'), desc29, DialogModes.NO );
}
}

// ===========================
// Find Similar Files / Folders
// ===========================
function script6() {
    var okButtonID = 1;
var layersOption = true;

if(mainDialog()==okButtonID)
{
    if(layersOption) mainLayer();
    else mainFolder();
}

function mainDialog()
{

     var dlg = new Window('dialog', 'Find same layers / folders');

    var d = dlg;

   
	d.margins=15;

    var gr1 = d.add('group');
	gr1.orientation = 'row';
    gr1.alignChildren = 'center';
	
    var layersRadio = gr1.add('radiobutton',undefined,"Layers");
    layersRadio.value = true;
    gr1.add('radiobutton',undefined,"Folders");
    
    d.c2 = d.add('group');	
    d.c2.margins = 5;
    d.c2.orientation = 'row';
    d.c2.alignChildren = 'center';
    var okButton = d.c2.add('button', undefined, 'OK', {
        name: 'ok'
    });
    d.c2.add('button', undefined, 'Cancel', {
        name: 'cancel'
    });


//events
    okButton.onClick = function()
    {
        layersOption = layersRadio.value;
        d.close(okButtonID);
    }

    
    return d.show();
}

function mainLayer(){
if(!documents.length) return;
var layerSets = getLayerSetNames_layer();
var str = layerSets.toString();
var Dups = new Array();
for(var a in layerSets){
var searchString=layerSets[a][1].toString();
var REX = new RegExp("\\b+" + searchString + '\\b','gi');
try{
if(str.match(REX).length> 1){
    Dups.push(layerSets[a]);
    }
}catch(e){}
}
if(Dups.length > 1){
deselectLayers();
for(var z in Dups){
    selectLayerById(Number(Dups[z][0]), true);
    }
}else{
    alert("There are no duplicate layer names");
    }
};

function mainFolder(){
var layerSets = getLayerSetNames_folder();
var str = layerSets.toString();
var Dups = new Array();
for(var a in layerSets){
var searchString= layerSets[a][1].toString();
var REX = new RegExp(searchString,'gi');
if(str.match(REX).length> 1) Dups.push(layerSets[a]);
}
if(Dups.length > 1){
deselectLayers();
for(var z in Dups){
    selectLayerById(Number(Dups[z][0]), true);
    }
}else{
    alert("There are no duplicate layerset names");
    }
};

function selectLayerById(ID, add) {
    add = (add == undefined)  ? add = false : add;
   var ref = new ActionReference();
   ref.putIdentifier(charIDToTypeID('Lyr '), ID);
   var desc = new ActionDescriptor();
   desc.putReference(charIDToTypeID('null'), ref);
   if (add) {
      desc.putEnumerated(stringIDToTypeID('selectionModifier'), stringIDToTypeID('selectionModifierType'), stringIDToTypeID('addToSelection'));
   }
   desc.putBoolean(charIDToTypeID('MkVs'), false);
   executeAction(charIDToTypeID('slct'), desc, DialogModes.NO);
};
function deselectLayers() { 
    var desc01 = new ActionDescriptor(); 
        var ref01 = new ActionReference(); 
        ref01.putEnumerated( charIDToTypeID('Lyr '), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') ); 
    desc01.putReference( charIDToTypeID('null'), ref01 ); 
    executeAction( stringIDToTypeID('selectNoLayers'), desc01, DialogModes.NO ); 
};
function getLayerSetNames_folder(){ 
   var ref = new ActionReference(); 
   ref.putEnumerated( charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') ); 
   var count = executeActionGet(ref).getInteger(charIDToTypeID('NmbL')) +1; 
   var Names=[];
try{
    activeDocument.backgroundLayer;
var i = 0; }catch(e){ var i = 1; };
   for(i;i<count;i++){ 
       if(i == 0) continue;
        ref = new ActionReference(); 
        ref.putIndex( charIDToTypeID( 'Lyr ' ), i );
        var desc = executeActionGet(ref);
        var layerName = desc.getString(charIDToTypeID( 'Nm  ' ));
        var Id = desc.getInteger(stringIDToTypeID( 'layerID' ));
        if(layerName.match(/^<\/Layer group/) ) continue;
        var layerType = typeIDToStringID(desc.getEnumerationValue( stringIDToTypeID( 'layerSection' )));
        var isLayerSet =( layerType == 'layerSectionContent') ? false:true;
if(isLayerSet) Names.push([[Id],[layerName]]);
   }; 
return Names;
};

function getLayerSetNames_layer(){ 
   var ref = new ActionReference(); 
   ref.putEnumerated( charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') ); 
   var count = executeActionGet(ref).getInteger(charIDToTypeID('NmbL')) +1; 
   var Names=[];
try{
    activeDocument.backgroundLayer;
var i = 0; }catch(e){ var i = 1; };
   for(i;i<count;i++){ 
       if(i == 0) continue;
        ref = new ActionReference(); 
        ref.putIndex( charIDToTypeID( 'Lyr ' ), i );
        var desc = executeActionGet(ref);
        var layerName = desc.getString(charIDToTypeID( 'Nm  ' ));
        var Id = desc.getInteger(stringIDToTypeID( 'layerID' ));
        if(layerName.match(/^<\/Layer group/) ) continue;
        var layerType = typeIDToStringID(desc.getEnumerationValue( stringIDToTypeID( 'layerSection' )));
        var isLayerSet =( layerType == 'layerSectionContent') ? false:true;
if(!isLayerSet) Names.push([[Id],[layerName]]);
   }; 
return Names;
};
}

// ===========================
// Convert to Smart Object
// ===========================
function script7() {
#target photoshop
var debug = false;
// Convert Selected Layers to Individual Smart Objects

var Layer = function(){}
var LayerSet = function(){}
var ArtLayer = function(){}
var Document = function(){}   

Document.prototype.convertToSmartObject=function(layerRef)
{

    this.activeLayer = layerRef;
try{
executeAction( stringIDToTypeID( "newPlacedLayer" ), undefined, DialogModes.NO );
}catch(e){log(e)}
    
}

var doc = app.activeDocument; 
    
doc.suspendHistory("Convert Selected Layers to Individual Smart Objects", "main()");

function main()
{
    
	var currentLayer = doc.activeLayer; // remember the selected layer
	var currentVisible = currentLayer.visible; // remember the visibility setting of the selected layer
	var currentSelectedLayers = getSelectedLayers(); // remember the selected layers

	if (currentSelectedLayers.length < 1){
		var currentLayer = doc.activeLayer; // remember the selected layers
	}

	// create an array and store all the art layers states
	var currentState = new Array;
	try{ 
		getCurrentStateAlteringAsNeeded(doc, currentState);
	}catch(e) {
		; // do nothing
	}
	
	// Do some voodoo on the layer selection incase no layer is selected or multiple layers are selected
	try{ 
		touchUpLayerSelection()
	}catch(e) {
		; // do nothing
	}
	
	// create an array and store all the art layers in that array
	var allArtLayers = new Array;
	var allVisibleInfo = new Array;
	getAllArtLayers(doc, allArtLayers, allVisibleInfo);
    
    
    


	// Walk the layer stack



    if (currentSelectedLayers.length < 1){
        try{
	doc.convertToSmartObject(currentLayer);
         }catch(e) {log(e)}   
	}

    var decrement = doc.artLayers[activeDocument.artLayers.length-1].isBackgroundLayer ? 0 : 1 ;
    
    
	for (var i = 0; i < currentSelectedLayers.length; i++){ 
		try{ 
			doc.convertToSmartObject(allArtLayers[allArtLayers.length-1-currentSelectedLayers[i]+decrement]);
		
		}catch(e) {log(e)}
	}


	// restore the current state of the layers
	try{ 
		setCurrentState(currentState);
	}catch(e) {
		; // do nothing
	}

	if (currentSelectedLayers.length > 1){
		try{ 
			setSelectedLayers(currentSelectedLayers);
		}catch(e) {
			; // do nothing
		}
	}

	// restore the selected layer
	try{ 
		doc.activeLayer = currentLayer;
	}catch(e) {
		; // do nothing
	}

	// restore the visibility setting of the original layer
	try{ 
		currentLayer.visible = currentVisible;
	}catch(e) {
		; // do nothing
	}

    
}


///////////////////////////////////////////////////////////////////////////////
// Function: touchUpLayerSelection
// Usage: deal with odd layer selections of no layer selected or multiple layers
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function touchUpLayerSelection() {
	try{ 
		// Select all Layers
		var idselectAllLayers = stringIDToTypeID( "selectAllLayers" );
			var desc252 = new ActionDescriptor();
			var idnull = charIDToTypeID( "null" );
				var ref174 = new ActionReference();
				var idLyr = charIDToTypeID( "Lyr " );
				var idOrdn = charIDToTypeID( "Ordn" );
				var idTrgt = charIDToTypeID( "Trgt" );
				ref174.putEnumerated( idLyr, idOrdn, idTrgt );
			desc252.putReference( idnull, ref174 );
		executeAction( idselectAllLayers, desc252, DialogModes.NO );
		// Select the previous layer
		var idslct = charIDToTypeID( "slct" );
			var desc209 = new ActionDescriptor();
			var idnull = charIDToTypeID( "null" );
				var ref140 = new ActionReference();
				var idLyr = charIDToTypeID( "Lyr " );
				var idOrdn = charIDToTypeID( "Ordn" );
				var idBack = charIDToTypeID( "Back" );
				ref140.putEnumerated( idLyr, idOrdn, idBack );
			desc209.putReference( idnull, ref140 );
			var idMkVs = charIDToTypeID( "MkVs" );
			desc209.putBoolean( idMkVs, false );
		executeAction( idslct, desc209, DialogModes.NO );
	}catch(e) {
		; // do nothing
	}
}


///////////////////////////////////////////////////////////////////////////////
// Function: getAllArtLayers
// Usage: get a reference to all artLayers in 
// the document, does recursion into groups
// Input: obj, current object, document or layerSet
// layersArray, place to put the resulting artLayers,
// layersArray is both input and output
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function getAllArtLayers(obj, layersArray, visibleArray) {
	for( var i = 0; i < obj.artLayers.length; i++) {
		layersArray.push(obj.artLayers[i]);
		//alert(obj.artLayers[i].name);
		visibleArray.push(obj.artLayers[i].visible);
	}
	for( var i = 0; i < obj.layerSets.length; i++) {
		getAllArtLayers(obj.layerSets[i], layersArray, visibleArray);	// recursive call
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: getSelectedLayers
// Usage: creates and array of the currently selected layers
// Input: <none> Must have an open document
// Return: Array selectedLayers
///////////////////////////////////////////////////////////////////////////////
function getSelectedLayers() {
	var selectedLayers = [];
	try {
		var backGroundCounter = activeDocument.artLayers[activeDocument.artLayers.length-1].isBackgroundLayer ? 0 : 1;
		var ref = new ActionReference();
		var keyTargetLayers = app.stringIDToTypeID( 'targetLayers' );
		ref.putProperty( app.charIDToTypeID( 'Prpr' ), keyTargetLayers );
		ref.putEnumerated( app.charIDToTypeID( 'Dcmn' ), app.charIDToTypeID( 'Ordn' ), app.charIDToTypeID( 'Trgt' ) );
		var desc = executeActionGet( ref );
		if ( desc.hasKey( keyTargetLayers ) ) {
			var layersList = desc.getList( keyTargetLayers );
			for ( var i = 0; i < layersList.count; i++) {
				var listRef = layersList.getReference( i );
				selectedLayers.push( listRef.getIndex() + backGroundCounter );
			}
		}
	}
	catch(e) {
		; // do nothing
	}
	return selectedLayers;
}

///////////////////////////////////////////////////////////////////////////////
// Function: setSelectedLayers
// Usage: Selects an array of layers
// Input:  Array selectedLayers
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function setSelectedLayers( layerIndexesOrNames ) {
	// first select the first one
	setSelectedLayer( layerIndexesOrNames[0] );

	// then add to the selection
	for ( var i = 1; i < layerIndexesOrNames.length; i++) {
		addSelectedLayer( layerIndexesOrNames[i] );
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: setSelectedLayer
// Usage: Selects the first layer
// Input:  Array selectedLayers
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function setSelectedLayer( layerIndexOrName ) {
	try {
		var id239 = charIDToTypeID( "slct" );
		var desc45 = new ActionDescriptor();
		var id240 = charIDToTypeID( "null" );
		var ref43 = new ActionReference();
		var id241 = charIDToTypeID( "Lyr " );
		if ( typeof layerIndexOrName == "number" ) {
			ref43.putIndex( id241, layerIndexOrName );
		} else {
			ref43.putName( id241, layerIndexOrName );
		}
		desc45.putReference( id240, ref43 );
		var id242 = charIDToTypeID( "MkVs" );
		desc45.putBoolean( id242, false );
		executeAction( id239, desc45, DialogModes.NO );
	}
	catch(e) {
		alert(e + ":" + e.line); // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function: addSelectedLayer
// Usage: adds the rest of the layers in the array to the first layer
// Input:  Array selectedLayers
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function addSelectedLayer( layerIndexOrName ) {
	try {
		var id243 = charIDToTypeID( "slct" );
		var desc46 = new ActionDescriptor();
		var id244 = charIDToTypeID( "null" );
		var ref44 = new ActionReference();
		var id245 = charIDToTypeID( "Lyr " );
		if ( typeof layerIndexOrName == "number" ) {
			ref44.putIndex( id245, layerIndexOrName );
		} else {
			ref44.putName( id245, layerIndexOrName );
		}
		desc46.putReference( id244, ref44 );
		var id246 = stringIDToTypeID( "selectionModifier" );
		var id247 = stringIDToTypeID( "selectionModifierType" );
		var id248 = stringIDToTypeID( "addToSelection" );
		desc46.putEnumerated( id246, id247, id248 );
		var id249 = charIDToTypeID( "MkVs" );
		desc46.putBoolean( id249, false );
		executeAction( id243, desc46, DialogModes.NO );
	}
	catch(e) {
		alert(e + ":" + e.line); // do nothing
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function:  getCurrentStateAlteringAsNeeded
// Usage: capture the current state of the layers in an array
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function getCurrentStateAlteringAsNeeded( obj, stateArray ) {
	for( var i = 0; i < obj.artLayers.length; i++) {
		var oState = new ObjectState(obj.artLayers[i]);
		if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].visible, true)) {
			obj.artLayers[i].visible = true;
		}
		if ( ! obj.artLayers[i].isBackgroundLayer) {
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].allLocked, false)) {
				obj.artLayers[i].allLocked = false;
			}
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].pixelsLocked, false)) {
				obj.artLayers[i].pixelsLocked = false;
			}
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].positionLocked, false)) {
				obj.artLayers[i].positionLocked = false;
			}
			if ( oState.fixState( obj.artLayers[i], obj.artLayers[i].transparentPixelsLocked, false)) {
				obj.artLayers[i].transparentPixelsLocked = false;
			}
		}
		stateArray.push(oState);
	}
	for( var i = 0; i < obj.layerSets.length; i++ ) {
		var oState = new ObjectState(obj.layerSets[i]);
		if ( oState.fixState( obj.layerSets[i], obj.layerSets[i].visible, true)) {
			obj.layerSets[i].visible = true;
		}
		if ( oState.fixState( obj.layerSets[i], obj.layerSets[i].allLocked, false)) {
			obj.layerSets[i].allLocked = false;
		}
		stateArray.push(oState);
		getCurrentStateAlteringAsNeeded(obj.layerSets[i], stateArray);	// recursive call
	}
}

///////////////////////////////////////////////////////////////////////////////
// Function:  setCurrentState
// Usage: set the state of the layers back to what what captured
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function setCurrentState(stateArray) {
	for ( var i = 0; i < stateArray.length; i++ ) {
		try {
			if (stateArray[i].altered) {
				app.refresh();
				activeDocument.activeLayer = stateArray[i].layer;
				stateArray[i].layer.allLocked = stateArray[i].allLocked;
				if ( ! stateArray[i].allLocked) {
					stateArray[i].layer.pixelsLocked = stateArray[i].pixelsLocked;
					stateArray[i].layer.positionLocked = stateArray[i].positionLocked;
					stateArray[i].layer.transparentPixelsLocked = stateArray[i].transparentPixelsLocked;
				}
				stateArray[i].layer.visible = stateArray[i].visible;
			}
		}
		catch(e) { alert(e + ":" + e.line); }
	}
}


///////////////////////////////////////////////////////////////////////////////
// Function:  ObjectState
// Usage: 
// Input: <none> Must have an open document
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function ObjectState( inObject ) {
	this.layer = inObject;
	this.visible = inObject.visible;
	this.allLocked = inObject.allLocked;
	this.pixelsLocked = inObject.pixelsLocked;
	this.positionLocked = inObject.positionLocked;
	this.transparentPixelsLocked = inObject.transparentPixelsLocked;
	this.altered = false;
	this.current = false;
	this.fixState = function (inObject, inState, wantState) {
		var wasAltered = false;
		if (inState != wantState) {
			if (this.current == false) {
				activeDocument.activeLayer = inObject;
				this.altered = true;
				this.current = true;
			}
			wasAltered = true;
		}
		return wasAltered;
	}
}

function log(msg)
{
if (debug) $.writeln(msg.toSource());    
}
}